
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="bottles_of_ibuprofen")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")

    # Set objective function
    m.setObjective(3*x0 + 1*x1 + 9*x2 + 2*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.02*x0 + 13.37*x1 + 20.33*x2 + 1.14*x3 <= 395, "weight_constraint")
    m.addConstr(20.33*x2 + 1.14*x3 >= 76, "diapers_lightbulbs_min_weight")
    m.addConstr(5.02*x0 + 20.33*x2 >= 52, "dish_soap_diapers_min_weight")
    m.addConstr(13.37*x1 + 20.33*x2 <= 146, "ibuprofen_diapers_max_weight")
    m.addConstr(13.37*x1 + 1.14*x3 <= 292, "ibuprofen_lightbulbs_max_weight")
    m.addConstr(5.02*x0 + 13.37*x1 <= 208, "dish_soap_ibuprofen_max_weight")
    m.addConstr(5.02*x0 + 1.14*x3 <= 163, "dish_soap_lightbulbs_max_weight")
    m.addConstr(13.37*x1 + 20.33*x2 + 1.14*x3 <= 206, "ibuprofen_diapers_lightbulbs_max_weight")
    m.addConstr(5.02*x0 + 13.37*x1 + 20.33*x2 + 1.14*x3 <= 206, "total_weight_constraint")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
