
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='dish_soap_bottles', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='bottles_of_ibuprofen', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='diapers', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(3*x1 + x2 + 9*x3 + 2*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20.33*x3 + 1.14*x4 >= 76)
    model.addConstr(5.02*x1 + 20.33*x3 >= 52)
    model.addConstr(13.37*x2 + 20.33*x3 <= 146)
    model.addConstr(13.37*x2 + 1.14*x4 <= 292)
    model.addConstr(5.02*x1 + 13.37*x2 <= 208)
    model.addConstr(5.02*x1 + 1.14*x4 <= 163)
    model.addConstr(13.37*x2 + 20.33*x3 + 1.14*x4 <= 206)
    model.addConstr(5.02*x1 + 13.37*x2 + 20.33*x3 + 1.14*x4 <= 395)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('dish soap bottles: ', x1.varValue)
        print('bottles of ibuprofen: ', x2.varValue)
        print('diapers: ', x3.varValue)
        print('lightbulbs: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
