
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_Mary")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_John")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_Hank")


    # Set objective function
    model.setObjective(9.69 * x0 + 4.91 * x1 + 9.83 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x0 + 6 * x2 >= 36, "c0")
    model.addConstr(3 * x0 + 7 * x1 + 6 * x2 >= 36, "c1")
    model.addConstr(4 * x1 + 8 * x2 >= 18, "c2")
    model.addConstr(1 * x0 + 8 * x2 >= 16, "c3")
    model.addConstr(1 * x0 + 4 * x1 + 8 * x2 >= 36, "c4")
    model.addConstr(-5 * x0 + 6 * x2 >= 0, "c5")
    model.addConstr(2 * x1 - 8 * x2 >= 0, "c6")
    model.addConstr(3 * x0 + 7 * x1 <= 110, "c7")
    model.addConstr(3 * x0 + 7 * x1 + 6 * x2 <= 63, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
