
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Mary
    x1 = model.addVar(name="x1", lb=0)  # hours worked by John
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Hank

    # Set variable bounds based on initial conditions
    x0.start = 1
    x1.start = 1
    x2.start = 1

    # Objective function
    model.setObjective(9.69 * x0 + 4.91 * x1 + 9.83 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 == 1, name="Mary_rating")
    model.addConstr(x1 == 1, name="John_rating")
    model.addConstr(x2 == 1, name="Hank_rating")
    model.addConstr(3 * x0 + 6 * x2 >= 36, name="min_paperwork")
    model.addConstr(3 * x0 + 7 * x1 + 6 * x2 >= 36, name="min_combined_paperwork")
    model.addConstr(4 * x1 + 8 * x2 >= 18, name="min_organization_combined")
    model.addConstr(x0 + 8 * x2 >= 16, name="min_organization")
    model.addConstr(x0 + 4 * x1 + 8 * x2 >= 36, name="total_organization")
    model.addConstr(-5 * x0 + 6 * x2 >= 0, name="balance_constraint1")
    model.addConstr(2 * x1 - 8 * x2 >= 0, name="balance_constraint2")
    model.addConstr(3 * x0 + 7 * x1 <= 110, name="max_paperwork_combined")
    model.addConstr(3 * x0 + 7 * x1 + 6 * x2 <= 63, name="max_total_paperwork")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Mary: ", x0.varValue)
        print("Hours worked by John: ", x1.varValue)
        print("Hours worked by Hank: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
