
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("maximize_value")

# Create variables
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
granola_bars = m.addVar(lb=0, vtype=GRB.INTEGER, name="granola_bars")


# Set objective function
m.setObjective(1 * bananas + 8 * granola_bars, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * bananas + 8 * granola_bars >= 38, "min_cost")
m.addConstr(11 * bananas + 9 * granola_bars >= 145, "min_health")
m.addConstr(-4 * bananas + 9 * granola_bars >= 0, "banana_granola_ratio")
m.addConstr(14 * bananas + 8 * granola_bars <= 111, "max_cost")
m.addConstr(11 * bananas + 9 * granola_bars <= 255, "max_health")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bananas: {bananas.x}")
    print(f"  Granola bars: {granola_bars.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

