
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="granola_bars")

# Set the objective function
m.setObjective(1*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 8*x2 >= 38, "min_cost")
m.addConstr(11*x1 + 9*x2 >= 145, "min_healthiness")
m.addConstr(-4*x1 + 9*x2 >= 0, "balance_constraint")
m.addConstr(14*x1 + 8*x2 <= 111, "max_cost")
m.addConstr(11*x1 + 9*x2 <= 255, "max_healthiness")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bananas: {x1.x}")
    print(f"Granola Bars: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
