
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bananas", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="granola_bars", lb=0, integrality=gurobi.GRB.INTEGER)  # Granola bars must be an integer

    # Objective function: maximize 1*bananas + 8*granola_bars
    model.setObjective(x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(14*x1 + 8*x2 >= 38, name="min_spend")
    model.addConstr(11*x1 + 9*x2 >= 145, name="min_healthiness")
    model.addConstr(-4*x1 + 9*x2 >= 0, name="relationship")
    model.addConstr(14*x1 + 8*x2 <= 111, name="max_spend")
    model.addConstr(11*x1 + 9*x2 <= 255, name="max_healthiness")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {x1.varValue}")
        print(f"Granola bars: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
