
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
    vitamin_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")

    # Set objective function
    m.setObjective(5.78 * calcium + 5.62 * vitamin_b7, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13 * calcium + 11 * vitamin_b7 >= 44, "kidney_support_min")
    m.addConstr(1 * calcium + 1 * vitamin_b7 >= 15, "cognitive_performance_min")
    m.addConstr(13 * calcium + 11 * vitamin_b7 >= 13, "muscle_growth_min")
    m.addConstr(4 * calcium - 9 * vitamin_b7 >= 0, "calcium_vitamin_ratio")
    m.addConstr(13 * calcium + 11 * vitamin_b7 <= 98, "kidney_support_max")
    m.addConstr(1 * calcium + 1 * vitamin_b7 <= 53, "cognitive_performance_max")
    m.addConstr(13 * calcium + 11 * vitamin_b7 <= 34, "muscle_growth_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution:")
        print(f"Milligrams of Calcium: {calcium.x}")
        print(f"Milligrams of Vitamin B7: {vitamin_b7.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
