
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_calcium", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_vitamin_B7")

    # Objective function
    model.setObjective(5.78 * x1 + 5.62 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13 * x1 >= 13, name="kidney_support_calcium")
    model.addConstr(1 * x1 >= 1, name="cognitive_performance_calcium")
    model.addConstr(13 * x1 >= 13, name="muscle_growth_calcium")
    model.addConstr(11 * x2 >= 11, name="kidney_support_B7")
    model.addConstr(1 * x2 >= 1, name="cognitive_performance_B7")
    model.addConstr(11 * x2 >= 11, name="muscle_growth_B7")
    model.addConstr(13 * x1 + 11 * x2 >= 44, name="total_kidney_support_min")
    model.addConstr(1 * x1 + 1 * x2 >= 15, name="total_cognitive_performance_min")
    model.addConstr(13 * x1 + 11 * x2 >= 13, name="total_muscle_growth_min")
    model.addConstr(4 * x1 - 9 * x2 >= 0, name="calcium_B7_relation")
    model.addConstr(13 * x1 + 11 * x2 <= 98, name="total_kidney_support_max")
    model.addConstr(1 * x1 + 1 * x2 <= 53, name="total_cognitive_performance_max")
    model.addConstr(13 * x1 + 11 * x2 <= 34, name="total_muscle_growth_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
