
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pies")
pizza = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pizza")
salad = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="salad")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sandwiches")

# Set objective function
m.setObjective(3.17 * bacon + 8.18 * pies + 6.91 * pizza + 8.42 * salad + 4.16 * sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * bacon + 8 * pies + 10 * pizza + 6 * salad + 12 * sandwiches <= 359, "budget")
m.addConstr(9 * bacon + 8 * pies >= 27, "bacon_pies_min")
m.addConstr(9 * bacon + 12 * sandwiches >= 53, "bacon_sandwiches_min")
m.addConstr(6 * salad + 12 * sandwiches >= 35, "salad_sandwiches_min")
m.addConstr(10 * pizza + 12 * sandwiches >= 40, "pizza_sandwiches_min")
m.addConstr(8 * pies + 12 * sandwiches >= 66, "pies_sandwiches_min")
m.addConstr(9 * bacon + 8 * pies + 10 * pizza + 6 * salad + 12 * sandwiches >= 66, "total_spend_min")
m.addConstr(9 * bacon + 8 * pies <= 143, "bacon_pies_max")
m.addConstr(8 * pies + 6 * salad <= 254, "pies_salad_max")
m.addConstr(8 * pies + 6 * salad + 12 * sandwiches <= 110, "pies_salad_sandwiches_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bacon: %g' % bacon.x)
    print('Pies: %g' % pies.x)
    print('Pizza: %g' % pizza.x)
    print('Salad: %g' % salad.x)
    print('Sandwiches: %g' % sandwiches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

