
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="strips_of_bacon", lb=0)  # No lower bound specified, but implied 0
x2 = m.addVar(name="cherry_pies", lb=0)  
x3 = m.addVar(name="slices_of_pizza", lb=0, integrality=gurobi.GRB.INTEGER)  # Must be an integer
x4 = m.addVar(name="bagged_salads", lb=0)  
x5 = m.addVar(name="peanutbutter_sandwiches", lb=0, integrality=gurobi.GRB.INTEGER)  # Must be an integer

# Objective function
m.setObjective(3.17*x1 + 8.18*x2 + 6.91*x3 + 8.42*x4 + 4.16*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(9*x1 + 8*x2 + 10*x3 + 6*x4 + 12*x5 >= 66)  
m.addConstr(9*x1 + 8*x2 >= 27)  
m.addConstr(9*x1 + 12*x5 >= 53)  
m.addConstr(6*x4 + 12*x5 >= 35)  
m.addConstr(10*x3 + 12*x5 >= 40)  
m.addConstr(8*x2 + 12*x5 >= 66)  
m.addConstr(9*x1 + 8*x2 <= 143)  
m.addConstr(8*x2 + 6*x4 <= 254)  
m.addConstr(8*x2 + 6*x4 + 12*x5 <= 110)  

# Set dollar cost constraint upper bound
m.addConstr(9*x1 + 8*x2 + 10*x3 + 6*x4 + 12*x5 <= 359)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", x1.varValue)
    print("Cherry pies: ", x2.varValue)
    print("Slices of pizza: ", x3.varValue)
    print("Bagged salads: ", x4.varValue)
    print("Peanutbutter sandwiches: ", x5.varValue)
else:
    print("The model is infeasible")
