
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
hydrangeas = m.addVar(vtype=gp.GRB.INTEGER, name="hydrangeas")
cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="cabbages")


# Set objective function
m.setObjective(5*sunflowers**2 + 8*sunflowers*hydrangeas + 2*sunflowers*cabbages + 7*hydrangeas**2 + 7*hydrangeas*cabbages + 3*cabbages**2 + 3*sunflowers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*sunflowers + 21*hydrangeas + 2*cabbages <= 128, "yield_constraint")
m.addConstr(22*sunflowers + 19*hydrangeas + 8*cabbages <= 127, "total_growth_constraint")
m.addConstr(22*sunflowers + 19*hydrangeas >= 44, "growth_sun_hydr_min")
m.addConstr(21*hydrangeas**2 + 2*cabbages**2 <= 128, "yield_squared_constraint")
m.addConstr(22*sunflowers + 19*hydrangeas <= 98, "growth_sun_hydr_max")
m.addConstr(22*sunflowers + 8*cabbages <= 53, "growth_sun_cabb_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('sunflowers:', sunflowers.x)
    print('hydrangeas:', hydrangeas.x)
    print('cabbages:', cabbages.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

