
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="sunflowers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="hydrangeas", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="decorative_cabbages", vtype=gurobi.GRB.INTEGER)

# Set the objective function
m.setObjective(5*x0**2 + 8*x0*x1 + 2*x0*x2 + 7*x1**2 + 7*x1*x2 + 3*x2**2 + 3*x0, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(22*x0 + 19*x1 >= 44)
m.addConstr(x1**2 + x2**2 <= 128)
m.addConstr(x0 + x1 + x2 <= 128)
m.addConstr(22*x0 + 19*x1 <= 98)
m.addConstr(22*x0 + 8*x2 <= 53)
m.addConstr(22*x0 + 19*x1 + 8*x2 <= 127)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Sunflowers: ", x0.varValue)
    print("Hydrangeas: ", x1.varValue)
    print("Decorative Cabbages: ", x2.varValue)
else:
    print("The model is infeasible")
