
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
    laura = model.addVar(lb=0, vtype=GRB.INTEGER, name="laura")
    mary = model.addVar(lb=0, vtype=GRB.INTEGER, name="mary")
    peggy = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")

    # Set objective function
    obj = 9.66*hank**2 + 2.25*hank*laura + 5.78*hank*mary + 9.13*hank*peggy + 7.01*laura**2 + 4.14*mary**2 + 3.29*peggy**2 + 8.94*mary
    model.setObjective(obj, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*hank + 7*mary >= 32)
    model.addConstr(11*laura + 7*mary >= 17)
    model.addConstr(11*laura + 4*peggy >= 21)
    model.addConstr(12*hank + 11*laura + 7*mary >= 40)
    model.addConstr(12*hank + 11*laura + 7*mary + 4*peggy >= 40)
    model.addConstr(16*hank + 14*mary >= 47)
    model.addConstr(14*mary**2 + 13*peggy**2 >= 56)
    model.addConstr(19*laura**2 + 14*mary**2 >= 22)
    model.addConstr(19*laura + 13*peggy >= 32)
    model.addConstr(16*hank + 19*laura >= 36)
    model.addConstr(16*hank + 13*peggy >= 20)
    model.addConstr(16*hank + 19*laura + 14*mary + 13*peggy >= 20)
    model.addConstr(-2*mary + 6*peggy >= 0)
    model.addConstr(-8*laura**2 + 7*mary**2 >= 0)
    model.addConstr(10*hank**2 - 8*peggy**2 >= 0)
    model.addConstr(11*laura**2 + 7*mary**2 <= 184)
    model.addConstr(12*hank + 4*peggy <= 103)
    model.addConstr(12*hank + 11*laura <= 52)
    model.addConstr(11*laura + 4*peggy <= 146)
    model.addConstr(12*hank**2 + 11*laura**2 + 4*peggy**2 <= 125)


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Hank:', hank.x)
        print('Laura:', laura.x)
        print('Mary:', mary.x)
        print('Peggy:', peggy.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
