
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0, integrality=gp.GRB.Integer)  # hours worked by Laura
x2 = m.addVar(name="x2", lb=0, integrality=gp.GRB.Integer)  # hours worked by Mary
x3 = m.addVar(name="x3", lb=0)  # hours worked by Peggy

# Objective function
m.setObjective(9.66 * x0**2 + 2.25 * x0 * x1 + 5.78 * x0 * x2 + 9.13 * x0 * x3 + 
               7.01 * x1**2 + 4.14 * x2**2 + 3.29 * x3**2 + 8.94 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(12 * x0 <= 184)
m.addConstr(16 * x0 <= 229)
m.addConstr(11 * x1 <= 184)
m.addConstr(19 * x1 <= 229)
m.addConstr(7 * x2 <= 184)
m.addConstr(14 * x2 <= 229)
m.addConstr(4 * x3 <= 184)
m.addConstr(13 * x3 <= 229)

m.addConstr(12 * x0 + 7 * x2 >= 32)
m.addConstr(11 * x1 + 7 * x2 >= 17)
m.addConstr(11 * x1 + 4 * x3 >= 21)
m.addConstr(12 * x0 + 11 * x1 + 7 * x2 >= 40)
m.addConstr(12 * x0 + 11 * x1 + 7 * x2 + 4 * x3 >= 40)

m.addConstr(16 * x0 + 14 * x2 >= 47)
m.addConstr(14**2 * x2**2 + 13**2 * x3**2 >= 56)
m.addConstr(19**2 * x1**2 + 14**2 * x2**2 >= 22)
m.addConstr(19 * x1 + 13 * x3 >= 32)
m.addConstr(16 * x0 + 19 * x1 >= 36)
m.addConstr(16 * x0 + 13 * x3 >= 20)
m.addConstr(16 * x0 + 19 * x1 + 14 * x2 + 13 * x3 >= 20)

m.addConstr(-2 * x2 + 6 * x3 >= 0)
m.addConstr(-8 * x1**2 + 7 * x2**2 >= 0)
m.addConstr(10 * x0**2 - 8 * x3**2 >= 0)

m.addConstr(11**2 * x1**2 + 7**2 * x2**2 <= 184**2)
m.addConstr(12 * x0 + 4 * x3 <= 103)
m.addConstr(12 * x0 + 11 * x1 <= 52)
m.addConstr(11 * x1 + 4 * x3 <= 146)
m.addConstr(12**2 * x0**2 + 11**2 * x1**2 + 4**2 * x3**2 <= 125**2)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
