
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    milkshakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milkshakes")
    cherry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
    ravioli = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ravioli")
    bananas = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bananas")

    # Set objective function
    m.setObjective(2*milkshakes + 8*cherry_pies + 5*ravioli + 7*bananas, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*cherry_pies + 3*bananas >= 44)
    m.addConstr(10*cherry_pies + 23*ravioli >= 20)
    m.addConstr(22*milkshakes + 23*ravioli >= 32)
    m.addConstr(22*milkshakes + 3*bananas >= 28)
    m.addConstr(22*milkshakes + 10*cherry_pies + 23*ravioli + 3*bananas >= 28)
    m.addConstr(2*milkshakes + 11*ravioli >= 17)
    m.addConstr(9*cherry_pies + 12*bananas >= 20)
    m.addConstr(2*milkshakes + 9*cherry_pies >= 25)
    m.addConstr(11*ravioli + 12*bananas >= 16)
    m.addConstr(9*cherry_pies + 11*ravioli + 12*bananas >= 27)
    m.addConstr(2*milkshakes + 9*cherry_pies + 11*ravioli + 12*bananas >= 27)
    m.addConstr(10*ravioli - 8*bananas >= 0)
    m.addConstr(milkshakes - 3*cherry_pies >= 0)
    m.addConstr(23*ravioli + 3*bananas <= 163)
    m.addConstr(10*cherry_pies + 23*ravioli <= 203)
    m.addConstr(22*milkshakes + 3*bananas <= 62)
    m.addConstr(2*milkshakes + 11*ravioli + 12*bananas <= 44)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model could not be solved to optimality.")

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
