
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milkshakes", lb=0)
x1 = model.addVar(name="cherry_pies", lb=0)
x2 = model.addVar(name="ravioli", lb=0)
x3 = model.addVar(name="bananas", lb=0)

# Objective function
model.setObjective(2*x0 + 8*x1 + 5*x2 + 7*x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(10*x2 - 8*x3 >= 0)
model.addConstr(x0 - 3*x1 >= 0)
model.addConstr(22*x0 + 10*x1 + 23*x2 + 3*x3 <= 210)
model.addConstr(2*x0 + 9*x1 + 11*x2 + 12*x3 <= 138)
model.addConstr(10*x1 + 3*x3 >= 44)
model.addConstr(10*x1 + 23*x2 >= 20)
model.addConstr(22*x0 + 23*x2 >= 32)
model.addConstr(22*x0 + 3*x3 >= 28)
model.addConstr(22*x0 + 10*x1 + 23*x2 + 3*x3 >= 28)
model.addConstr(2*x0 + 11*x2 >= 17)
model.addConstr(9*x1 + 12*x3 >= 20)
model.addConstr(2*x0 + 9*x1 >= 25)
model.addConstr(11*x2 + 12*x3 >= 16)
model.addConstr(9*x1 + 11*x2 + 12*x3 >= 27)
model.addConstr(2*x0 + 9*x1 + 11*x2 + 12*x3 >= 27)
model.addConstr(23*x2 + 3*x3 <= 163)
model.addConstr(10*x1 + 23*x2 <= 203)
model.addConstr(22*x0 + 3*x3 <= 62)
model.addConstr(2*x0 + 11*x2 + 12*x3 <= 44)

# Optimize the model
model.optimize()

# Print the solution
print("Objective: ", model.objVal)
print("Milkshakes: ", x0.varValue)
print("Cherry Pies: ", x1.varValue)
print("Ravioli: ", x2.varValue)
print("Bananas: ", x3.varValue)

# Symbolic representation
print("Symbolic Representation:")
print("Variables: ")
print([('x0', 'milkshakes'), ('x1', 'cherry pies'), ('x2', 'ravioli'), ('x3', 'bananas')])
print("Objective Function: 2*x0 + 8*x1 + 5*x2 + 7*x3")
print("Constraints: ")
print("1. 10*x2 - 8*x3 >= 0")
print("2. x0 - 3*x1 >= 0")
print("3. 22*x0 + 10*x1 + 23*x2 + 3*x3 <= 210")
print("4. 2*x0 + 9*x1 + 11*x2 + 12*x3 <= 138")
print("5. 10*x1 + 3*x3 >= 44")
print("6. 10*x1 + 23*x2 >= 20")
print("7. 22*x0 + 23*x2 >= 32")
print("8. 22*x0 + 3*x3 >= 28")
print("9. 22*x0 + 10*x1 + 23*x2 + 3*x3 >= 28")
print("10. 2*x0 + 11*x2 >= 17")
print("11. 9*x1 + 12*x3 >= 20")
print("12. 2*x0 + 9*x1 >= 25")
print("13. 11*x2 + 12*x3 >= 16")
print("14. 9*x1 + 11*x2 + 12*x3 >= 27")
print("15. 2*x0 + 9*x1 + 11*x2 + 12*x3 >= 27")
print("16. 23*x2 + 3*x3 <= 163")
print("17. 10*x1 + 23*x2 <= 203")
print("18. 22*x0 + 3*x3 <= 62")
print("19. 2*x0 + 11*x2 + 12*x3 <= 44")

