
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, names=["George", "Jean", "Dale", "Ringo", "Bill"])

# Set objective function
m.setObjective(1*x[0] + 4*x[1] + 2*x[2] + 4*x[3] + 8*x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.93*x[3] + 2.49*x[4] >= 18)
m.addConstr(4.64*x[2] + 2.49*x[4] >= 41)
m.addConstr(1.38*x[1] + 3.93*x[3] + 2.49*x[4] >= 47)
m.addConstr(1.38*x[1] + 4.64*x[2] + 2.49*x[4] >= 47)
m.addConstr(1.38*x[1] + 3.93*x[3] + 2.49*x[4] >= 43)
m.addConstr(1.38*x[1] + 4.64*x[2] + 2.49*x[4] >= 43)
m.addConstr(3.74*x[1] + 1.07*x[4] >= 12)
m.addConstr(5.04*x[0] + 3.74*x[1] >= 15)
m.addConstr(3.74*x[1] + 5.86*x[3] >= 14)
m.addConstr(0.56*x[2] + 1.07*x[4] >= 14)
m.addConstr(5.04*x[0] + 0.56*x[2] >= 10)
m.addConstr(5.04*x[0] + 0.56*x[2] + 1.07*x[4] >= 16)
m.addConstr(3.93*x[3] + 2.49*x[4] <= 129)
m.addConstr(1.29*x[0] + 1.38*x[1] <= 207)
m.addConstr(4.64*x[2] + 3.93*x[3] <= 214)
m.addConstr(1.29*x[0] + 1.38*x[1] + 4.64*x[2] + 3.93*x[3] + 2.49*x[4] <= 214)
m.addConstr(5.04*x[0] + 3.74*x[1] <= 94)
m.addConstr(3.74*x[1] + 1.07*x[4] <= 149)
m.addConstr(5.04*x[0] + 1.07*x[4] <= 86)
m.addConstr(3.74*x[1] + 0.56*x[2] <= 124)
m.addConstr(5.04*x[0] + 5.86*x[3] <= 82)
m.addConstr(5.86*x[3] + 1.07*x[4] <= 84)
m.addConstr(0.56*x[2] + 1.07*x[4] <= 87)
m.addConstr(5.04*x[0] + 3.74*x[1] + 0.56*x[2] + 5.86*x[3] + 1.07*x[4] <= 87)
m.addConstr(5.22*x[0] + 4.63*x[4] <= 27)
m.addConstr(1.67*x[1] + 2.74*x[3] <= 79)
m.addConstr(1.67*x[1] + 3.29*x[2] + 4.63*x[4] <= 85)
m.addConstr(1.67*x[1] + 3.29*x[2] + 2.74*x[3] <= 45)
m.addConstr(5.22*x[0] + 1.67*x[1] + 3.29*x[2] <= 51)
m.addConstr(5.22*x[0] + 2.74*x[3] + 4.63*x[4] <= 66)
m.addConstr(5.22*x[0] + 3.29*x[2] + 4.63*x[4] <= 54)
m.addConstr(1.67*x[1] + 2.74*x[3] + 4.63*x[4] <= 67)
m.addConstr(5.22*x[0] + 1.67*x[1] + 2.74*x[3] <= 81)
m.addConstr(3.29*x[2] + 2.74*x[3] + 4.63*x[4] <= 42)
m.addConstr(5.22*x[0] + 1.67*x[1] + 3.29*x[2] + 2.74*x[3] + 4.63*x[4] <= 42)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

