
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', lb=0)  # hours worked by George
x1 = model.addVar(name='x1', lb=0)  # hours worked by Jean
x2 = model.addVar(name='x2', lb=0)  # hours worked by Dale
x3 = model.addVar(name='x3', lb=0)  # hours worked by Ringo
x4 = model.addVar(name='x4', lb=0)  # hours worked by Bill

# Define the objective function
model.setObjective(1*x0 + 4*x1 + 2*x2 + 4*x3 + 8*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3.93*x3 + 2.49*x4 >= 18)
model.addConstr(4.64*x2 + 2.49*x4 >= 41)
model.addConstr(1.38*x1 + 3.93*x3 + 2.49*x4 >= 47)
model.addConstr(1.38*x1 + 4.64*x2 + 2.49*x4 >= 47)
model.addConstr(1.38*x1 + 3.93*x3 + 2.49*x4 >= 43)
model.addConstr(1.38*x1 + 4.64*x2 + 2.49*x4 >= 43)
model.addConstr(3.74*x1 + 1.07*x4 >= 12)
model.addConstr(5.04*x0 + 3.74*x1 >= 15)
model.addConstr(3.74*x1 + 5.86*x3 >= 14)
model.addConstr(0.56*x2 + 1.07*x4 >= 14)
model.addConstr(5.04*x0 + 0.56*x2 >= 10)
model.addConstr(5.04*x0 + 0.56*x2 + 1.07*x4 >= 16)
model.addConstr(3.93*x3 + 2.49*x4 <= 129)
model.addConstr(1.29*x0 + 1.38*x1 <= 207)
model.addConstr(4.64*x2 + 3.93*x3 <= 214)
model.addConstr(1.29*x0 + 1.38*x1 + 4.64*x2 + 3.93*x3 + 2.49*x4 <= 214)
model.addConstr(5.04*x0 + 3.74*x1 <= 94)
model.addConstr(3.74*x1 + 1.07*x4 <= 149)
model.addConstr(5.04*x0 + 1.07*x4 <= 86)
model.addConstr(3.74*x1 + 0.56*x2 <= 124)
model.addConstr(5.04*x0 + 5.86*x3 <= 82)
model.addConstr(5.86*x3 + 1.07*x4 <= 84)
model.addConstr(0.56*x2 + 1.07*x4 <= 87)
model.addConstr(5.04*x0 + 3.74*x1 + 0.56*x2 + 5.86*x3 + 1.07*x4 <= 87)
model.addConstr(5.22*x0 + 4.63*x4 <= 27)
model.addConstr(1.67*x1 + 2.74*x3 <= 79)
model.addConstr(1.67*x1 + 3.29*x2 + 4.63*x4 <= 85)
model.addConstr(1.67*x1 + 3.29*x2 + 2.74*x3 <= 45)
model.addConstr(5.22*x0 + 1.67*x1 + 3.29*x2 <= 51)
model.addConstr(5.22*x0 + 2.74*x3 + 4.63*x4 <= 66)
model.addConstr(5.22*x0 + 3.29*x2 + 4.63*x4 <= 54)
model.addConstr(1.67*x1 + 2.74*x3 + 4.63*x4 <= 67)
model.addConstr(5.22*x0 + 1.67*x1 + 2.74*x3 <= 81)
model.addConstr(3.29*x2 + 2.74*x3 + 4.63*x4 <= 42)
model.addConstr(5.22*x0 + 1.67*x1 + 3.29*x2 + 2.74*x3 + 4.63*x4 <= 42)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Hours worked by George: ', x0.varValue)
    print('Hours worked by Jean: ', x1.varValue)
    print('Hours worked by Dale: ', x2.varValue)
    print('Hours worked by Ringo: ', x3.varValue)
    print('Hours worked by Bill: ', x4.varValue)
else:
    print('No optimal solution found')
