
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("kidney_support")

    # Create variables
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")


    # Set objective function
    m.setObjective(9 * calcium + 2 * protein + 8 * vitamin_b9, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7.69 * calcium + 6.48 * protein + 3.53 * vitamin_b9 >= 64, "c1")
    m.addConstr(6.48 * protein + 3.53 * vitamin_b9 >= 47, "c2")
    m.addConstr(6.48 * protein + 3.53 * vitamin_b9 <= 157, "c3")
    m.addConstr(7.69 * calcium + 3.53 * vitamin_b9 <= 158, "c4")
    m.addConstr(7.69 * calcium + 6.48 * protein <= 192, "c5")
    m.addConstr(7.69 * calcium + 6.48 * protein + 3.53 * vitamin_b9 <= 192, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium: %g' % calcium.x)
        print('protein: %g' % protein.x)
        print('vitamin_b9: %g' % vitamin_b9.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
