
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_calcium", lb=0)  # No upper bound given
    x2 = model.addVar(name="grams_of_protein", lb=0)   # No upper bound given
    x3 = model.addVar(name="milligrams_of_vitamin_B9", lb=0)  # No upper bound given

    # Define the objective function
    model.setObjective(9 * x1 + 2 * x2 + 8 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6.48 * x2 + 3.53 * x3 >= 47)
    model.addConstr(7.69 * x1 + 6.48 * x2 + 3.53 * x3 >= 64)
    model.addConstr(6.48 * x2 + 3.53 * x3 <= 157)
    model.addConstr(7.69 * x1 + 3.53 * x3 <= 158)
    model.addConstr(7.69 * x1 + 6.48 * x2 <= 192)
    model.addConstr(7.69 * x1 + 6.48 * x2 + 3.53 * x3 <= 192)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Grams of protein: {x2.varValue}")
        print(f"Milligrams of vitamin B9: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
