
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("WorkOptimization")

    # Create variables
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
    john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
    laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
    jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")


    # Set objective function
    model.setObjective(7.73 * bill + 6.89 * john + 8.6 * laura + 6.81 * jean, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * bill + 8 * john >= 43, "c1")
    model.addConstr(9 * bill + 13 * jean >= 24, "c2")
    model.addConstr(8 * john + 14 * laura >= 38, "c3")
    model.addConstr(9 * bill + 8 * john + 14 * laura + 13 * jean >= 43, "c4")
    model.addConstr(-bill + 2 * john >= 0, "c5")
    model.addConstr(-6 * bill + 8 * laura >= 0, "c6")
    model.addConstr(8 * john + 14 * laura <= 174, "c7")
    model.addConstr(9 * bill + 13 * jean <= 121, "c8")
    model.addConstr(9 * bill + 8 * john <= 119, "c9")
    model.addConstr(8 * john + 13 * jean <= 118, "c10")
    model.addConstr(9 * bill + 8 * john + 14 * laura <= 72, "c11")
    model.addConstr(9 * bill + 8 * john + 13 * jean <= 100, "c12")
    model.addConstr(8 * john + 14 * laura + 13 * jean <= 173, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
