
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Bill', lb=0)  # Bill
    x2 = model.addVar(name='hours_worked_by_John', lb=0)   # John
    x3 = model.addVar(name='hours_worked_by_Laura', lb=0)  # Laura
    x4 = model.addVar(name='hours_worked_by_Jean', lb=0)   # Jean

    # Objective function
    model.setObjective(7.73 * x1 + 6.89 * x2 + 8.6 * x3 + 6.81 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x2 + 14 * x3 >= 38)
    model.addConstr(9 * x1 + 13 * x4 >= 24)
    model.addConstr(9 * x1 + 8 * x2 >= 43)
    model.addConstr(9 * x1 + 8 * x2 + 14 * x3 + 13 * x4 >= 43)
    model.addConstr(-x1 + 2 * x2 >= 0)
    model.addConstr(-6 * x1 + 8 * x3 >= 0)
    model.addConstr(8 * x2 + 14 * x3 <= 174)
    model.addConstr(9 * x1 + 13 * x4 <= 121)
    model.addConstr(9 * x1 + 8 * x2 <= 119)
    model.addConstr(8 * x2 + 13 * x4 <= 118)
    model.addConstr(9 * x1 + 8 * x2 + 14 * x3 <= 72)
    model.addConstr(9 * x1 + 8 * x2 + 13 * x4 <= 100)
    model.addConstr(8 * x2 + 14 * x3 + 13 * x4 <= 173)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Bill: ', x1.varValue)
        print('Hours worked by John: ', x2.varValue)
        print('Hours worked by Laura: ', x3.varValue)
        print('Hours worked by Jean: ', x4.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
