
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_iron")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")


# Set objective function
m.setObjective(8*x0**2 + 4*x0*x1 + x0*x3 + 7*x0*x4 + 6*x1**2 + 6*x1*x3 + 7*x1*x4 + 4*x2**2 + 7*x2*x3 + x2*x4 + 4*x3*x4 + 3*x4**2 + 8*x0 + 7*x2 + 3*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + 11*x1 + 15*x2 + 22*x3 + 5*x4 <= 263)
m.addConstr(14*x0 + 18*x1 + 4*x2 + 11*x3 + 20*x4 <= 332)
m.addConstr(11*x1 + 15*x2 >= 33)
m.addConstr(15**2*x2**2 + 22**2*x3**2 >= 42)
m.addConstr(x0 + x1 >= 43)
m.addConstr(18*x1 + 4*x2 >= 64)
m.addConstr(14*x0 + 4*x2 >= 61)
m.addConstr(14*x0 + 11*x3 >= 34)
m.addConstr(14**2*x0**2 + 20**2*x4**2 >= 25)
m.addConstr(4*x2 + 20*x4 >= 49)
m.addConstr(18*x1 + 11*x3 >= 60)
m.addConstr(-9*x0**2 + 9*x1**2 + 5*x4**2 >= 0)
m.addConstr(22*x3 + 5*x4 <= 147)
m.addConstr(15**2*x2**2 + 5**2*x4**2 <= 142)
m.addConstr(x0**2 + 5**2*x4**2 <= 258)
m.addConstr(x0**2 + 22**2*x3**2 <= 97)
m.addConstr(11*x1 + 5*x4 <= 131)
m.addConstr(x0 + x3 + x4 <= 67)
m.addConstr(x0 + x1 + x4 <= 56)
m.addConstr(15**2*x2**2 + 22**2*x3**2 + 5**2*x4**2 <= 205)
m.addConstr(x0 + x1 + x2 + x3 + x4 <= 205)
m.addConstr(4*x2 + 11*x3 <= 160)
m.addConstr(14*x0 + 4*x2 <= 201)
m.addConstr(11**2*x3**2 + 20**2*x4**2 <= 108)
m.addConstr(18*x1 + 4*x2 + 20*x4 <= 322)
m.addConstr(14*x0 + 18*x1 + 11*x3 <= 67)
m.addConstr(14*x0 + 18*x1 + 4*x2 + 11*x3 + 20*x4 <= 67)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

