
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # grams of fiber
x1 = m.addVar(name="x1", lb=0)  # grams of carbohydrates
x2 = m.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # milligrams of iron
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin B2
x4 = m.addVar(name="x4", lb=0)  # milligrams of potassium

# Define the objective function
m.setObjective(8*x0**2 + 4*x0*x1 + x0*x3 + 7*x0*x4 + 6*x1**2 + 6*x1*x3 + 7*x1*x4 + 4*x2**2 + 7*x2*x3 + x2*x4 + 4*x3*x4 + 3*x4**2 + 8*x0 + 7*x2 + 3*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x1 + 15*x2 + 22*x3 + 5*x4 >= 33)
m.addConstr(15**2*x2 + 22**2*x3 >= 42)
m.addConstr(x0 + 11*x1 >= 43)
m.addConstr(18*x1 + 4*x2 >= 64)
m.addConstr(14*x0 + 4*x2 >= 61)
m.addConstr(14*x0 + 11*x3 >= 34)
m.addConstr(14**2*x0 + 20**2*x4 >= 25)
m.addConstr(4*x2 + 20*x4 >= 49)
m.addConstr(18*x1 + 11*x3 >= 60)
m.addConstr(-9*x0**2 + 9*x1**2 + 5*x4**2 >= 0)
m.addConstr(22*x3 + 5*x4 <= 147)
m.addConstr(15**2*x2 + 5**2*x4 <= 142)
m.addConstr(x0 + 5**2*x4 <= 258)
m.addConstr(x0 + 22**2*x3 <= 97)
m.addConstr(11*x1 + 5*x4 <= 131)
m.addConstr(x0 + 22*x3 + 5*x4 <= 67)
m.addConstr(x0 + 11*x1 + 5*x4 <= 56)
m.addConstr(15**2*x2 + 22**2*x3 + 5**2*x4 <= 205)
m.addConstr(x0 + x1 + x2 + x3 + x4 <= 205)
m.addConstr(4*x2 + 11*x3 <= 160)
m.addConstr(14*x0 + 4*x2 <= 201)
m.addConstr(11**2*x3 + 20**2*x4 <= 108)
m.addConstr(18*x1 + 4*x2 + 20*x4 <= 322)
m.addConstr(14*x0 + 18*x1 + 11*x3 <= 67)
m.addConstr(14*x0 + 18*x1 + 4*x2 + 11*x3 + 20*x4 <= 67)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
