
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(name="kiwis", lb=0.0)  # Non-negative, continuous
strawberries = m.addVar(name="strawberries", vtype=GRB.INTEGER, lb=0) # Non-negative, integer


# Set objective function
m.setObjective(kiwis**2 + 3*kiwis*strawberries + 7*strawberries**2 + 9*kiwis + 3*strawberries, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.97*kiwis + 4.63*strawberries >= 71, "tastiness_min")
m.addConstr(8*kiwis**2 - 8*strawberries**2 >= 0, "kiwi_strawberry_relation")
m.addConstr(1.97*kiwis + 4.63*strawberries <= 138, "tastiness_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {kiwis.x}")
    print(f"Strawberries: {strawberries.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

