
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    kiwis = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="kiwis", vtype=gurobi.GRB.CONTINUOUS)
    strawberries = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="strawberries", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(kiwis**2 + 3*kiwis*strawberries + 7*strawberries**2 + 9*kiwis + 3*strawberries, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.97*kiwis + 4.63*strawberries >= 71, name="tastiness_rating_min")
    model.addConstr(1.97*kiwis + 4.63*strawberries <= 138, name="tastiness_rating_max")
    model.addConstr(8*kiwis**2 - 8*strawberries**2 >= 0, name="tastiness_rating_diff")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Kiwis: {kiwis.varValue}")
        print(f"Strawberries: {strawberries.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has no optimal solution.")

solve_optimization_problem()
