
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("office_supplies")

    # Create variables
    x = {}
    x[0] = m.addVar(vtype=gp.GRB.INTEGER, name="yellow_highlighters")
    x[1] = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
    x[2] = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
    x[3] = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")


    # Set objective function
    m.setObjective(5*x[0] + 8*x[1] + 4*x[2] + 2*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*x[1] + 5*x[3] >= 23)
    m.addConstr(9*x[0] + 6*x[1] >= 17)
    m.addConstr(6*x[1] + 7*x[2] >= 30)
    m.addConstr(9*x[0] + 7*x[2] >= 25)
    m.addConstr(9*x[0] + 6*x[1] + 7*x[2] + 5*x[3] >= 25)
    m.addConstr(10*x[1] + 2*x[2] >= 16)
    m.addConstr(8*x[0] + 10*x[1] >= 15)
    m.addConstr(2*x[2] + 8*x[3] >= 10)
    m.addConstr(10*x[1] + 8*x[3] >= 14)
    m.addConstr(8*x[0] + 2*x[2] >= 24)
    m.addConstr(8*x[0] + 10*x[1] + 2*x[2] + 8*x[3] >= 24)
    m.addConstr(3*x[1] - x[2] >= 0)
    m.addConstr(4*x[0] - x[1] >= 0)
    m.addConstr(6*x[1] + 7*x[2] <= 105)
    m.addConstr(6*x[1] + 7*x[2] + 5*x[3] <= 126)
    m.addConstr(9*x[0] + 6*x[1] + 7*x[2] <= 59)
    m.addConstr(9*x[0] + 7*x[2] + 5*x[3] <= 61)
    m.addConstr(8*x[0] + 8*x[3] <= 70)
    m.addConstr(8*x[0] + 10*x[1] + 2*x[2] <= 72)
    m.addConstr(10*x[1] + 2*x[2] + 8*x[3] <= 79)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName} = {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
