
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="yellow_highlighters", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="manila_envelopes", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x0 + 8*x1 + 4*x2 + 2*x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 5*x3 >= 23)
m.addConstr(9*x0 + 6*x1 >= 17)
m.addConstr(6*x1 + 7*x2 >= 30)
m.addConstr(9*x0 + 7*x2 >= 25)
m.addConstr(9*x0 + 6*x1 + 7*x2 + 5*x3 >= 25)
m.addConstr(10*x1 + 2*x2 >= 16)
m.addConstr(8*x0 + 10*x1 >= 15)
m.addConstr(2*x2 + 8*x3 >= 10)
m.addConstr(10*x1 + 8*x3 >= 14)
m.addConstr(8*x0 + 2*x2 >= 24)
m.addConstr(8*x0 + 10*x1 + 2*x2 + 8*x3 >= 24)
m.addConstr(3*x1 - x2 >= 0)
m.addConstr(4*x0 - x1 >= 0)
m.addConstr(6*x1 + 7*x2 <= 105)
m.addConstr(6*x1 + 7*x2 + 5*x3 <= 126)
m.addConstr(9*x0 + 6*x1 + 7*x2 <= 59)
m.addConstr(9*x0 + 7*x2 + 5*x3 <= 61)
m.addConstr(8*x0 + 8*x3 <= 70)
m.addConstr(8*x0 + 10*x1 + 2*x2 <= 72)
m.addConstr(10*x1 + 2*x2 + 8*x3 <= 79)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Yellow Highlighters: ", x0.varValue)
    print("Paper Clips: ", x1.varValue)
    print("Packs of Paper: ", x2.varValue)
    print("Manila Envelopes: ", x3.varValue)
else:
    print("The model is infeasible")
