
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")


    # Set objective function
    m.setObjective(6*x0 + 3*x1 + 3*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 9*x1 >= 47)
    m.addConstr(6*x0 + 9*x1 + 8*x2 >= 47)
    m.addConstr(21*x0 + 21*x1 >= 84)
    m.addConstr(21*x1 + 20*x2 >= 33)
    m.addConstr(21*x0 + 20*x2 >= 37)
    m.addConstr(21*x0 + 21*x1 + 20*x2 >= 98)
    m.addConstr(10*x0 + 17*x2 >= 18)
    m.addConstr(19*x1 + 17*x2 >= 42)
    m.addConstr(10*x0 + 19*x1 + 17*x2 >= 29)
    m.addConstr(6*x0 - 5*x2 >= 0)

    # Resource Constraints
    m.addConstr(6*x0 + 9*x1 + 8*x2 <= 234) # Protein
    m.addConstr(21*x0 + 21*x1 + 20*x2 <= 303) # Iron
    m.addConstr(10*x0 + 19*x1 + 17*x2 <= 126) # Fiber


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
