
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="chicken_breasts", lb=0)  
x1 = m.addVar(name="fruit_salads", lb=0)    
x2 = m.addVar(name="ham_sandwiches", lb=0)  

# Define the objective function
m.setObjective(6 * x0 + 3 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 + 9 * x1 >= 47)  
m.addConstr(6 * x0 + 9 * x1 + 8 * x2 >= 47)  
m.addConstr(21 * x0 + 21 * x1 >= 84)  
m.addConstr(21 * x1 + 20 * x2 >= 33)  
m.addConstr(21 * x0 + 20 * x2 >= 37)  
m.addConstr(21 * x0 + 21 * x1 + 20 * x2 >= 98)
m.addConstr(10 * x0 + 17 * x2 >= 18)  
m.addConstr(19 * x1 + 17 * x2 >= 42)  
m.addConstr(10 * x0 + 19 * x1 + 17 * x2 >= 29)  
m.addConstr(6 * x0 - 5 * x2 >= 0)  

# Update the model
m.update()

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken breasts: ", x0.varValue)
    print("Fruit salads: ", x1.varValue)
    print("Ham sandwiches: ", x2.varValue)
else:
    print("The model is infeasible")
