
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
zinc = m.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc")


# Set objective function
m.setObjective(6 * vitamin_e + 3 * vitamin_a + 3 * zinc, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * vitamin_e + 20 * vitamin_a + 16 * zinc <= 135, "digestive_support_index_limit")
m.addConstr(vitamin_e + 2 * vitamin_a + zinc <= 296, "kidney_support_index_limit")

m.addConstr(20 * vitamin_a + 16 * zinc >= 33, "digestive_support_a_zinc_min")
m.addConstr(21 * vitamin_e + 16 * zinc >= 39, "digestive_support_e_zinc_min")

m.addConstr(2 * vitamin_a + zinc <= 121, "kidney_support_a_zinc_max")
m.addConstr(vitamin_e + 2 * vitamin_a + zinc <= 121, "kidney_support_all_max")

m.addConstr(21 * vitamin_e + 16 * zinc <= 133, "digestive_support_e_zinc_max")
m.addConstr(21 * vitamin_e + 20 * vitamin_a + 16 * zinc <= 133, "digestive_support_all_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_e:', vitamin_e.x)
    print('vitamin_a:', vitamin_a.x)
    print('zinc:', zinc.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

