
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Scheduling")

# Create variables
jean = model.addVar(vtype=GRB.INTEGER, name="jean")
hank = model.addVar(vtype=GRB.INTEGER, name="hank")
bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
peggy = model.addVar(vtype=GRB.INTEGER, name="peggy")
bill = model.addVar(vtype=GRB.INTEGER, name="bill")


# Set objective function
model.setObjective(6.6 * jean + 7.62 * hank + 8.55 * bobby + 6.91 * peggy + 7.67 * bill, GRB.MAXIMIZE)

# Add constraints
model.addConstr(jean + 7 * hank + 3 * bobby + 4 * peggy + 8 * bill <= 146, "r0")
model.addConstr(2 * jean + 8 * hank + 6 * bobby + peggy + 2 * bill <= 164, "r1")
model.addConstr(8 * jean + hank + 7 * bobby + 8 * peggy + bill <= 82, "r2")

# ... (rest of the constraints from the JSON "constraints" field)
# Example:
model.addConstr(jean + hank + bill >= 20, "c1")
# ... add all other constraints similarly

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Jean:', jean.x)
    print('Hank:', hank.x)
    print('Bobby:', bobby.x)
    print('Peggy:', peggy.x)
    print('Bill:', bill.x)

elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

