 
import gurobi as gp

m = gp.Model("optimization_problem")

x1 = m.addVar(name="hours_worked_by_Jean", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Hank", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="hours_worked_by_Bobby", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="hours_worked_by_Peggy", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)

m.setObjective(6.6*x1 + 7.62*x2 + 8.55*x3 + 6.91*x4 + 7.67*x5, gp.GRB.MAXIMIZE)

# Work quality
m.addConstr(1*x1 + 7*x2 + 8*x5 >= 20)
m.addConstr(1*x1 + 3*x3 + 4*x4 >= 20)
m.addConstr(1*x1 + 7*x2 + 4*x4 >= 20)
m.addConstr(1*x1 + 3*x3 + 8*x5 >= 20)
m.addConstr(1*x1 + 4*x4 + 8*x5 >= 20)
m.addConstr(1*x1 + 7*x2 + 3*x3 >= 20)
m.addConstr(1*x1 + 7*x2 + 8*x5 >= 27)
m.addConstr(1*x1 + 3*x3 + 4*x4 >= 27)
m.addConstr(1*x1 + 7*x2 + 4*x4 >= 27)
m.addConstr(1*x1 + 3*x3 + 8*x5 >= 27)
m.addConstr(1*x1 + 4*x4 + 8*x5 >= 27)
m.addConstr(1*x1 + 7*x2 + 3*x3 >= 27)
m.addConstr(1*x1 + 7*x2 + 8*x5 >= 29)
m.addConstr(1*x1 + 3*x3 + 4*x4 >= 29)
m.addConstr(1*x1 + 7*x2 + 4*x4 >= 29)
m.addConstr(1*x1 + 3*x3 + 8*x5 >= 29)
m.addConstr(1*x1 + 4*x4 + 8*x5 >= 29)
m.addConstr(1*x1 + 7*x2 + 3*x3 >= 29)

# Paperwork
m.addConstr(2*x1 + 8*x2 >= 18)
m.addConstr(6*x3 + 1*x4 + 2*x5 >= 18)
m.addConstr(2*x1 + 2*x5 + 8*x2 >= 18)
m.addConstr(6*x3 + 1*x4 + 2*x5 >= 27)
m.addConstr(2*x1 + 8*x2 + 2*x5 >= 27)

# Computer
m.addConstr(8*x1 + 1*x5 >= 5)
m.addConstr(7*x3 + 8*x4 >= 9)
m.addConstr(7*x3 + 1*x5 >= 8)
m.addConstr(8*x1 + 8*x4 >= 7)

# Bounds
m.addConstr(1*x1 + 4*x4 <= 90)
m.addConstr(1*x1 + 7*x2 <= 89)
m.addConstr(7*x2 + 3*x3 <= 144)
m.addConstr(3*x3 + 4*x4 <= 29)
m.addConstr(1*x1 + 7*x2 + 3*x3 <= 138)
m.addConstr(1*x1 + 7*x2 + 4*x4 <= 125)
m.addConstr(7*x2 + 4*x4 + 8*x5 <= 81)
m.addConstr(1*x1 + 7*x2 + 8*x5 <= 134)
m.addConstr(7*x2 + 3*x3 + 8*x5 <= 117)
m.addConstr(1*x1 + 7*x2 + 3*x3 + 4*x4 + 8*x5 <= 117)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
    print("Hours worked by Peggy: ", x4.varValue)
    print("Hours worked by Bill: ", x5.varValue)
else:
    print("No optimal solution found")
