
from gurobipy import Model, GRB, QuadExpr

# Create a new model
model = Model("optimize_work_hours")

# Create variables
dale_hours = model.addVar(name="dale_hours")
hank_hours = model.addVar(name="hank_hours")

# Set objective function
obj = QuadExpr()
obj += 4 * dale_hours * dale_hours
obj += 6 * dale_hours * hank_hours
obj += 7 * dale_hours
model.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * dale_hours + 4 * hank_hours >= 29, "computer_competence_min")
model.addConstr(-8 * dale_hours + 6 * hank_hours >= 0, "work_ratio")
model.addConstr(4 * dale_hours + 4 * hank_hours <= 70, "computer_competence_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Dale: {dale_hours.x}')
    print(f'Hours worked by Hank: {hank_hours.x}')
    print(f'Objective Value: {model.objVal}')
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {model.status}.')

