
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Dale", lb=0)  # Hours worked by Dale
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)   # Hours worked by Hank

# Set the objective function
m.setObjective(4*x1**2 + 6*x1*x2 + 7*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 <= 82, name="Dale_competence_rating")
m.addConstr(4*x2 <= 82, name="Hank_competence_rating")
m.addConstr(4*x1 + 4*x2 >= 29, name="Min_total_competence_rating")
m.addConstr(-8*x1 + 6*x2 >= 0, name="Specific_linear_constraint")
m.addConstr(4*x1 + 4*x2 <= 70, name="Max_total_competence_rating")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Dale: {x1.x}")
    print(f"Hours worked by Hank: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
