
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Dale", lb=-gp.GRB.INFINITY)  # No lower bound specified
x2 = m.addVar(name="hours_worked_by_Hank", lb=-gp.GRB.INFINITY)  # No lower bound specified

# Define the objective function
m.setObjective(4*x1**2 + 6*x1*x2 + 7*x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 4*x2 >= 29, name="min_computer_competence_rating")
m.addConstr(-8*x1 + 6*x2 >= 0, name="linear_constraint")
m.addConstr(4*x1 + 4*x2 <= 70, name="max_computer_competence_rating")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x1.varValue}")
    print(f"Hours worked by Hank: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
