
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    hamburgers = m.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")
    black_beans = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
    hot_dogs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hot_dogs")


    # Set objective function
    m.setObjective(3 * hamburgers + 1 * black_beans + 5 * hot_dogs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(24 * hamburgers + 13 * black_beans >= 87, "tastiness_hamburgers_black_beans_min")
    m.addConstr(13 * black_beans + 16 * hot_dogs >= 30, "tastiness_black_beans_hot_dogs_min")
    m.addConstr(21 * hamburgers + 25 * black_beans >= 38, "iron_hamburgers_black_beans_min")
    m.addConstr(25 * black_beans + 24 * hot_dogs >= 41, "iron_black_beans_hot_dogs_min")
    m.addConstr(13 * black_beans + 16 * hot_dogs <= 190, "tastiness_black_beans_hot_dogs_max")
    m.addConstr(24 * hamburgers + 13 * black_beans <= 148, "tastiness_hamburgers_black_beans_max")
    m.addConstr(24 * hamburgers + 13 * black_beans + 16 * hot_dogs <= 148, "tastiness_total_max")
    m.addConstr(21 * hamburgers + 24 * hot_dogs <= 87, "iron_hamburgers_hot_dogs_max")
    m.addConstr(25 * black_beans + 24 * hot_dogs <= 72, "iron_black_beans_hot_dogs_max")
    m.addConstr(21 * hamburgers + 25 * black_beans <= 120, "iron_hamburgers_black_beans_max")
    m.addConstr(21 * hamburgers + 25 * black_beans + 24 * hot_dogs <= 120, "iron_total_max")

    # Resource Constraints
    m.addConstr(24 * hamburgers <= 270, "tastiness_hamburgers_limit")
    m.addConstr(13 * black_beans <= 142, "tastiness_black_beans_limit")
    m.addConstr(16 * hot_dogs <= 270, "tastiness_hot_dogs_limit")
    m.addConstr(21 * hamburgers <= 142, "iron_hamburgers_limit")
    m.addConstr(25 * black_beans <= 142, "iron_black_beans_limit")
    m.addConstr(24 * hot_dogs <= 142, "iron_hot_dogs_limit")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('hamburgers:', hamburgers.x)
        print('black_beans:', black_beans.x)
        print('hot_dogs:', hot_dogs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
