
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hamburgers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="hot_dogs")

# Define the objective function
m.setObjective(3*x0 + x1 + 5*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(24*x0 + 13*x1 >= 87)
m.addConstr(13*x1 + 16*x2 >= 30)
m.addConstr(21*x0 + 25*x1 >= 38)
m.addConstr(25*x1 + 24*x2 >= 41)
m.addConstr(13*x1 + 16*x2 <= 190)
m.addConstr(24*x0 + 13*x1 <= 148)
m.addConstr(24*x0 + 13*x1 + 16*x2 <= 148)
m.addConstr(21*x0 + 24*x2 <= 87)
m.addConstr(25*x1 + 24*x2 <= 72)
m.addConstr(21*x0 + 25*x1 <= 120)
m.addConstr(21*x0 + 25*x1 + 24*x2 <= 120)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hamburgers: ", x0.varValue)
    print("Black Beans: ", x1.varValue)
    print("Hot Dogs: ", x2.varValue)
else:
    print("The model is infeasible")
