
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
candles = m.addVar(vtype=GRB.INTEGER, name="candles")
packs_of_paper_plates = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
paper_towel_rolls = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
cartons_of_milk = m.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")
toilet_paper_rolls = m.addVar(vtype=GRB.INTEGER, name="toilet_paper_rolls")
packs_of_napkins = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")


# Set objective function
m.setObjective(4*candles*packs_of_paper_plates + 3*candles*packs_of_napkins + 6*packs_of_paper_plates**2 + packs_of_paper_plates*toilet_paper_rolls + 2*packs_of_paper_plates*packs_of_napkins + 9*paper_towel_rolls**2 + 9*paper_towel_rolls*packs_of_napkins + 2*cartons_of_milk*toilet_paper_rolls + 5*cartons_of_milk*packs_of_napkins + 9*toilet_paper_rolls**2 + 9*paper_towel_rolls + 5*toilet_paper_rolls + 9*packs_of_napkins, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*candles + 12*packs_of_paper_plates + 2*paper_towel_rolls + 2*cartons_of_milk + 5*toilet_paper_rolls + 9*packs_of_napkins <= 305)
m.addConstr(8*candles + 5*packs_of_paper_plates + 12*paper_towel_rolls + 7*cartons_of_milk + 7*toilet_paper_rolls + 4*packs_of_napkins <= 201)
# ... (add all other constraints similarly, substituting variable names)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

