
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")

# Set objective function
m.setObjective(8.4 * green_beans + 6.91 * hamburgers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * green_beans + 4 * hamburgers >= 10, "calcium_requirement1")
m.addConstr(5 * green_beans + 4 * hamburgers >= 10, "calcium_requirement2")  # Duplicate constraint
m.addConstr(1 * green_beans - 1 * hamburgers >= 0, "green_beans_more_than_hamburgers")
m.addConstr(5 * green_beans + 4 * hamburgers <= 21, "calcium_upper_bound")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Green beans: {green_beans.x}")
    print(f"Hamburgers: {hamburgers.x}")
    print(f"Objective value: {m.objVal}")

