
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="green_beans")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hamburgers")

# Set the objective function
m.setObjective(8.4*x1 + 6.91*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 >= 10, "calcium_minimum")
m.addConstr(x1 - x2 >= 0, "green_beans_more_than_hamburgers")
m.addConstr(5*x1 + 4*x2 <= 21, "calcium_maximum")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Green beans: {x1.x}")
    print(f"Hamburgers: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
