
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    green_beans = model.addVar(lb=0, name="green_beans", vtype=gurobi.GRB.CONTINUOUS)
    hamburgers = model.addVar(lb=0, name="hamburgers", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(8.4 * green_beans + 6.91 * hamburgers, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * green_beans + 4 * hamburgers >= 10, name="total_calcium")
    model.addConstr(5 * green_beans >= 10, name="green_beans_calcium")
    model.addConstr(4 * hamburgers >= 10, name="hamburgers_calcium")
    model.addConstr(green_beans - hamburgers >= 0, name="balance")
    model.addConstr(5 * green_beans + 4 * hamburgers <= 21, name="calcium_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Green beans: {green_beans.varValue}")
        print(f"Hamburgers: {hamburgers.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
