
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("muscle_growth")

    # Create variables
    x = m.addVars(5, lb=0, name=["carbohydrates", "vitamin_B3", "iron", "fat", "zinc"])

    # Set objective function
    m.setObjective(4.23 * x[0] + 6.92 * x[1] + 2.74 * x[2] + 4.93 * x[3] + 9.41 * x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * x[0] + 5 * x[3] >= 28)
    m.addConstr(5 * x[1] + 11 * x[4] >= 30)
    m.addConstr(x[2] + 5 * x[3] >= 44)
    m.addConstr(5 * x[3] + 11 * x[4] >= 32)
    m.addConstr(11 * x[0] + x[2] >= 26)
    m.addConstr(5 * x[1] + 5 * x[3] <= 143)
    m.addConstr(x[2] + 5 * x[3] <= 173)
    m.addConstr(5 * x[1] + 11 * x[4] <= 73)
    m.addConstr(5 * x[3] + 11 * x[4] <= 96)
    m.addConstr(11 * x[0] + 5 * x[1] <= 97)
    m.addConstr(11 * x[0] + x[2] <= 140)
    m.addConstr(x[2] + 11 * x[4] <= 193)
    m.addConstr(11 * x[0] + 5 * x[3] <= 174)
    m.addConstr(11 * x[0] + 5 * x[1] + 5 * x[3] <= 50)
    m.addConstr(5 * x[1] + x[2] + 11 * x[4] <= 200)
    m.addConstr(11 * x[0] + 5 * x[1] + 11 * x[4] <= 147)
    m.addConstr(11 * x[0] + 5 * x[1] + x[2] <= 180)
    m.addConstr(11 * x[0] + x[2] + 11 * x[4] <= 91)
    m.addConstr(11 * x[0] + 5 * x[3] + 11 * x[4] <= 225)
    m.addConstr(11 * x[0] + 5 * x[1] + x[2] + 5 * x[3] + 11 * x[4] <= 225)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
