
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # grams of carbohydrates
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B3
    x3 = model.addVar(name="x3", lb=0)  # milligrams of iron
    x4 = model.addVar(name="x4", lb=0)  # grams of fat
    x5 = model.addVar(name="x5", lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(4.23 * x1 + 6.92 * x2 + 2.74 * x3 + 4.93 * x4 + 9.41 * x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * x1 + 5 * x2 + x3 + 5 * x4 + 11 * x5 <= 231)
    model.addConstr(11 * x1 + 5 * x4 >= 28)
    model.addConstr(5 * x2 + 11 * x5 >= 30)
    model.addConstr(x3 + 5 * x4 >= 44)
    model.addConstr(5 * x4 + 11 * x5 >= 32)
    model.addConstr(11 * x1 + x3 >= 26)
    model.addConstr(5 * x2 + 5 * x4 <= 143)
    model.addConstr(x3 + 5 * x4 <= 173)
    model.addConstr(5 * x2 + 11 * x5 <= 73)
    model.addConstr(5 * x4 + 11 * x5 <= 96)
    model.addConstr(11 * x1 + 5 * x2 <= 97)
    model.addConstr(11 * x1 + x3 <= 140)
    model.addConstr(x3 + 11 * x5 <= 193)
    model.addConstr(11 * x1 + 5 * x4 <= 174)
    model.addConstr(11 * x1 + 5 * x2 + 5 * x4 <= 50)
    model.addConstr(5 * x2 + x3 + 11 * x5 <= 200)
    model.addConstr(11 * x1 + 5 * x2 + 11 * x5 <= 147)
    model.addConstr(11 * x1 + 5 * x2 + x3 <= 180)
    model.addConstr(11 * x1 + x3 + 11 * x5 <= 91)
    model.addConstr(11 * x1 + 5 * x4 + 11 * x5 <= 225)
    model.addConstr(11 * x1 + 5 * x2 + x3 + 5 * x4 + 11 * x5 <= 225)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("The model is infeasible")

optimize()
