
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")

# Set objective function
m.setObjective(1*x0 + 4*x1 + 2*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21*x0 + 20*x1 + 1*x2 <= 134, "c0")
m.addConstr(26*x0 + 9*x1 + 9*x2 <= 168, "c1")
m.addConstr(24*x0 + 24*x1 + 5*x2 <= 187, "c2")
m.addConstr(26*x0 + 19*x1 + 2*x2 <= 146, "c3")
m.addConstr(1*x0 + 5*x1 + 10*x2 <= 133, "c4")
m.addConstr(26*x0 + 2*x2 >= 16, "c5")
m.addConstr(19*x1 + 2*x2 >= 39, "c6")
m.addConstr(1*x0 + 5*x1 + 10*x2 >= 36, "c7")
m.addConstr(21*x0 + 20*x1 <= 48, "c8")
m.addConstr(21*x0 + 1*x2 <= 88, "c9")
m.addConstr(20*x1 + 1*x2 <= 112, "c10")
m.addConstr(21*x0 + 20*x1 + 1*x2 <= 112, "c11")
m.addConstr(26*x0 + 9*x2 <= 102, "c12")
m.addConstr(9*x1 + 9*x2 <= 117, "c13")
m.addConstr(26*x0 + 9*x1 + 9*x2 <= 117, "c14")
m.addConstr(24*x0 + 5*x2 <= 178, "c15")
m.addConstr(24*x0 + 24*x1 <= 62, "c16")
m.addConstr(24*x0 + 24*x1 + 5*x2 <= 143, "c17")
m.addConstr(26*x0 + 19*x1 <= 52, "c18")
m.addConstr(19*x1 + 2*x2 <= 139, "c19")
m.addConstr(26*x0 + 19*x1 + 2*x2 <= 139, "c20")
m.addConstr(1*x0 + 10*x2 <= 103, "c21")
m.addConstr(5*x1 + 10*x2 <= 129, "c22")
m.addConstr(1*x0 + 5*x1 + 10*x2 <= 129, "c23")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

