
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='automatic_alerts', vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name='patches_per_day', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='pen_testers', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(1*x0 + 4*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(21*x0 + 20*x1 + 1*x2 <= 134)
model.addConstr(26*x0 + 9*x1 + 9*x2 <= 168)
model.addConstr(24*x0 + 24*x1 + 5*x2 <= 187)
model.addConstr(26*x0 + 19*x1 + 2*x2 <= 146)
model.addConstr(1*x0 + 5*x1 + 10*x2 <= 133)
model.addConstr(26*x0 + 2*x2 >= 16)
model.addConstr(19*x1 + 2*x2 >= 39)
model.addConstr(1*x0 + 5*x1 + 10*x2 >= 36)
model.addConstr(21*x0 + 20*x1 <= 48)
model.addConstr(21*x0 + 1*x2 <= 88)
model.addConstr(20*x1 + 1*x2 <= 112)
model.addConstr(21*x0 + 20*x1 + 1*x2 <= 112)
model.addConstr(26*x0 + 9*x2 <= 102)
model.addConstr(9*x1 + 9*x2 <= 117)
model.addConstr(26*x0 + 9*x1 + 9*x2 <= 117)
model.addConstr(24*x0 + 5*x2 <= 178)
model.addConstr(24*x0 + 24*x1 <= 62)
model.addConstr(24*x0 + 24*x1 + 5*x2 <= 143)
model.addConstr(26*x0 + 19*x1 <= 52)
model.addConstr(19*x1 + 2*x2 <= 139)
model.addConstr(26*x0 + 19*x1 + 2*x2 <= 139)
model.addConstr(1*x0 + 10*x2 <= 103)
model.addConstr(5*x1 + 10*x2 <= 129)
model.addConstr(1*x0 + 5*x1 + 10*x2 <= 129)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Automatic alerts: ', x0.varValue)
    print('Patches per day: ', x1.varValue)
    print('Pen testers: ', x2.varValue)
else:
    print('The model is infeasible')
