
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    ramen = m.addVar(lb=0, name="ramen")
    apple_pie = m.addVar(lb=0, name="apple_pie")
    cheeseburger = m.addVar(lb=0, name="cheeseburger")
    cherry_pie = m.addVar(lb=0, name="cherry_pie")
    ham_sandwich = m.addVar(lb=0, name="ham_sandwich")


    # Set objective function
    m.setObjective(6*ramen + 7*apple_pie + 5*cheeseburger + 5*cherry_pie + 6*ham_sandwich, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.72*apple_pie + 1.61*ham_sandwich >= 15)
    m.addConstr(11.31*ramen + 12.33*cheeseburger >= 18)
    m.addConstr(12.33*cheeseburger + 1.61*ham_sandwich >= 33)
    m.addConstr(12.33*cheeseburger + 11.32*cherry_pie >= 14)
    m.addConstr(12.33*cheeseburger + 11.32*cherry_pie + 1.61*ham_sandwich >= 21)
    m.addConstr(11.31*ramen + 12.33*cheeseburger + 1.61*ham_sandwich >= 21)
    m.addConstr(12.33*cheeseburger + 11.32*cherry_pie + 1.61*ham_sandwich >= 23)
    m.addConstr(11.31*ramen + 12.33*cheeseburger + 1.61*ham_sandwich >= 23)
    m.addConstr(11.31*ramen + 0.72*apple_pie + 12.33*cheeseburger + 11.32*cherry_pie + 1.61*ham_sandwich >= 23)
    m.addConstr(11.31*ramen + 0.72*apple_pie <= 57)
    m.addConstr(11.31*ramen + 0.72*apple_pie + 11.32*cherry_pie <= 87)
    m.addConstr(11.31*ramen + 12.33*cheeseburger + 1.61*ham_sandwich <= 163)
    m.addConstr(11.31*ramen + 0.72*apple_pie + 12.33*cheeseburger <= 126)
    m.addConstr(11.31*ramen + 11.32*cherry_pie + 1.61*ham_sandwich <= 70)
    m.addConstr(0.72*apple_pie + 12.33*cheeseburger + 1.61*ham_sandwich <= 92)
    m.addConstr(11.31*ramen + 0.72*apple_pie + 1.61*ham_sandwich <= 147)
    m.addConstr(11.31*ramen + 0.72*apple_pie + 12.33*cheeseburger + 11.32*cherry_pie + 1.61*ham_sandwich <= 185)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
