
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', lb=0)  # bowls of instant ramen
    x2 = model.addVar(name='x2', lb=0)  # apple pies
    x3 = model.addVar(name='x3', lb=0)  # cheeseburgers
    x4 = model.addVar(name='x4', lb=0)  # cherry pies
    x5 = model.addVar(name='x5', lb=0)  # ham sandwiches

    # Objective function
    model.setObjective(6 * x1 + 7 * x2 + 5 * x3 + 5 * x4 + 6 * x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.72 * x2 + 1.61 * x5 >= 15)
    model.addConstr(11.31 * x1 + 12.33 * x3 >= 18)
    model.addConstr(12.33 * x3 + 1.61 * x5 >= 33)
    model.addConstr(12.33 * x3 + 11.32 * x4 >= 14)
    model.addConstr(12.33 * x3 + 11.32 * x4 + 1.61 * x5 >= 21)
    model.addConstr(11.31 * x1 + 12.33 * x3 + 1.61 * x5 >= 21)
    model.addConstr(12.33 * x3 + 11.32 * x4 + 1.61 * x5 >= 23)
    model.addConstr(11.31 * x1 + 12.33 * x3 + 1.61 * x5 >= 23)
    model.addConstr(11.31 * x1 + 0.72 * x2 + 12.33 * x3 + 11.32 * x4 + 1.61 * x5 >= 23)
    model.addConstr(11.31 * x1 + 0.72 * x2 <= 57)
    model.addConstr(11.31 * x1 + 0.72 * x2 + 11.32 * x4 <= 87)
    model.addConstr(11.31 * x1 + 12.33 * x3 + 1.61 * x5 <= 163)
    model.addConstr(11.31 * x1 + 0.72 * x2 + 12.33 * x3 <= 126)
    model.addConstr(11.31 * x1 + 11.32 * x4 + 1.61 * x5 <= 70)
    model.addConstr(0.72 * x2 + 12.33 * x3 + 1.61 * x5 <= 92)
    model.addConstr(11.31 * x1 + 0.72 * x2 + 1.61 * x5 <= 147)
    model.addConstr(11.31 * x1 <= 185)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
