
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_trees")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")

    # Set objective function
    m.setObjective(6.23 * x0 + 4.36 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19 * x0 + 9 * x1 >= 88, "water_need_min")
    m.addConstr(18 * x0 + 30 * x1 >= 59, "planting_space_min")
    m.addConstr(8 * x0 + 32 * x1 >= 24, "beauty_rating_min")
    m.addConstr(5 * x0 + 27 * x1 >= 98, "growth_speed_min")
    m.addConstr(25 * x0 + 1 * x1 >= 32, "yield_min")
    m.addConstr(7 * x0 - 3 * x1 >= 0, "constraint_6")
    m.addConstr(19 * x0 + 9 * x1 <= 221, "water_need_max")
    m.addConstr(18 * x0 + 30 * x1 <= 62, "planting_space_max")
    m.addConstr(8 * x0 + 32 * x1 <= 39, "beauty_rating_max")
    m.addConstr(5 * x0 + 27 * x1 <= 289, "growth_speed_max")
    m.addConstr(25 * x0 + 1 * x1 <= 161, "yield_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cherry_trees:', x0.x)
        print('sunflowers:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

